/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_ERRORS_H_
#define _SCE_ERRORS_H_

#include "utility_errors.h"

//-------------------------------------------------------------------
// Internal Errors (not thrown back to user code)
//-------------------------------------------------------------------
#ifndef SCE_TOOLKIT_NP_SUCCESS
#define SCE_TOOLKIT_NP_SUCCESS											0			///< The operation was successfully completed.
#endif

#ifndef SCE_TOOLKIT_NP_INVALID_POINTER
#define SCE_TOOLKIT_NP_INVALID_POINTER									0x81000011	///< An error occurred because an invalid pointer was passed as an argument.
#endif

#ifndef SCE_TOOLKIT_NP_OUT_OF_MEMORY
#define SCE_TOOLKIT_NP_OUT_OF_MEMORY									0x81000012	///< An error occurred because memory allocation failed.
#endif

#ifndef SCE_TOOLKIT_NP_INVALID_ARGUMENT
#define SCE_TOOLKIT_NP_INVALID_ARGUMENT									0x81000013	///< An error occurred because an argument to a method was incorrect.
#endif
//------------------------------
#define SCE_TOOLKIT_NP_POLLING_COMPLETE									1				///< The operation was successfully completed and polling is no longer needed.			

//-------------------------------------------------------------------
// External Errors
//-------------------------------------------------------------------
//e-initialization errors
#define SCE_TOOLKIT_NP_INIT_ERRORS										0x81000000	///< An error was caused during the execution of initialization code.
#define SCE_TOOLKIT_NP_INIT_INVALID_MEM_MANAGER							0x81000001	///< An error occurred because the memory manager passed as an argument that was invalid.
#define SCE_TOOLKIT_NP_FAILED_ALLOCATE									0x81000002  ///< An error occurred because the %NP %Toolkit library failed to allocate memory for an object.
#define SCE_TOOLKIT_NP_ALREADY_INITIALISED								0x81000003  ///< An error occurred because the %NP %Toolkit library has already been initialized.
#define SCE_TOOLKIT_NP_INIT_START_THREAD								0x81000004	///< An error occurred because the thread starting function failed. This was most likely due to locking errors.
#define SCE_TOOLKIT_NP_TERMINATED										0x81000005	///< An error occurred because the %NP %Toolkit library has been terminated.
#define SCE_TOOLKIT_NP_FUTURE_IS_IN_USE									0x81000006	///< An error occurred because the <c>Future</c> object passed as an argument is already in use.

#define SCE_TOOLKIT_NP_GENERIC_ERRORS									0x81000010	///< A generic %NP %Toolkit library error.
#define SCE_TOOLKIT_NP_INVALID_MODULE									0x81000014	///< An error occurred because the module specified was an invalid ID.
#define SCE_TOOLKIT_NP_MODULE_NOT_OWNED									0x81000015	///< An error occurred because a module was not owned by %NP %Toolkit library, and therefore could not be loaded or unloaded.
#define SCE_TOOLKIT_NP_NOT_INITIALISED									0x81000016	///< An error occurred because the %NP %Toolkit library was not initialized.
#define SCE_TOOLKIT_NP_OUT_OF_DISKSPACE									0x81000017	///< An error occurred because there was no more disk space.
#define SCE_TOOLKIT_NP_NETWORK_ERROR									0x81000018	///< A network error occurred during execution of an operation.
#define SCE_TOOLKIT_NP_OFFLINE											0x81000019	///< A network error occurred as the network was unavailable.
#define SCE_TOOLKIT_NP_OPERATION_IN_PROGRESS							0x8100001A	///< An error occurred because two operations that cannot be performed concurrently were requested. For example, clashing system utilities.
//e- General Service Errors
#define SCE_TOOLKIT_NP_SERVICE_ID_NOT_OVERRIDEN							0x81000021	///< An error occurred because the service could not override the ID required.
#define SCE_TOOLKIT_NP_SERVICE_OFFLINE									0x81000022	///< An error occurred because the %NP %Toolkit library tried to bring the service up while offline.
#define SCE_TOOLKIT_NP_TERMINATION_NOT_SUPPORTED						0x81000023	///< An error occurred because termination of the requested service is not supported. 
#define SCE_TOOLKIT_NP_SERVICE_NOT_INITIALISED							0x81000024	///< An error occurred because the %NP %Toolkit library tried to perform an action on a service which has not been initialized.

//e- Trophy errors
#define	SCE_TOOLKIT_NP_TROPHY_UPDATE_ERROR								0x83000001	///< An error occurred because the trophy list cache cannot be updated.
#define SCE_TOOLKIT_NP_TROPHY_NOT_INITIALISED							0x83000002	///< An error occurred because the trophy service has not been initialized.
#define SCE_TOOLKIT_NP_TROPHY_NOT_REGISTERED							0x83000003	///< An error occurred because the trophy set file has not been registered.
#define SCE_TOOLKIT_NP_TROPHY_REGISTERING								0x83000004	///< An error occurred because an attempt to register another trophy is still processing.
#define SCE_TOOLKIT_NP_TROPHY_ABORT_FAIL								0x83000005	///< An error occurred because an to abort a trophy registration failed.
#define SCE_TOOLKIT_NP_TROPHY_SETUP_DIALOG_ALREADY_RUNNING				0x83000006	///< An error occurred because an attempt was made invoke more than one setup dialog at the same time.
#define SCE_TOOLKIT_NP_TROPHY_BUSY										0x83000007	///< An error occurred because the trophy service is processing a long request.
#define SCE_TOOLKIT_NP_TROPHY_ALREADY_REGISTERED						0x83000008	///< An error occurred because the trophy set is already registered.
#define SCE_TOOLKIT_NP_TROPHY_NOT_TERMINATED							0x87000009  ///< An error occurred because the trophy service has not been terminated.
#define SCE_TOOLKIT_NP_TROPHY_NOT_ENOUGH_SPACE							0x8700000A	///< An error occurred because there is not enough space to install the trophy set.

//e-Presence errors
#define SCE_TOOLKIT_NP_PRESENCE_STRING_TOO_LONG							0x84000001	///< An error occurred because the string passed into the %NP %Toolkit library was too long for setting presence details.
#define SCE_TOOLKIT_NP_PRESENCE_DATA_TOO_BIG							0x84000002	///< An error occurred because the data passed into <c>PresenceInterface::setPresence()</c> was too big.
#define SCE_TOOLKIT_NP_PRESENCE_NO_TOKENS								0x84000003	///< An error occurred because all the presence tokens had been used up.

//e-message sending errors
#define SCE_TOOLKIT_NP_MESSAGE_USER_CANCEL								0x81000030	///< An error occurred because the user canceled the sending of a message.
#define SCE_TOOLKIT_NP_MESSAGE_DATA_TOO_LARGE							0x81000031	///< An error occurred because the attachment data was too large.
#define SCE_TOOLKIT_NP_MESSAGE_TYPE_MISMATCH							0x81000032	///< An error occurred because the message specification was invalid.
#define SCE_TOOLKIT_NP_MESSAGE_NO_DATA									0x81000033	///< An error occurred because there was no waiting data attachment.
#define SCE_TOOLKIT_NP_MESSAGE_ATTACHMENT_INVALID						0x81000034	///< An error occurred because the attachment data is not valid.
//e-Ranking errors
#define SCE_TOOLKIT_NP_RANKING_SLOT_FULL								0x85000001	///< An error occurred because the transaction ID slots are full. There are only 6 slots available. 
#define SCE_TOOLKIT_NP_RANKING_NOT_INITIALISED							0x85000002	///< An error occurred because an attempt was made to execute ranking services without initializing them first.
#define SCE_TOOLKIT_NP_RANKING_NO_MATCHING_BOARD						0x85000003	///< An error occurred because there is no ranking board in the cache.
#define SCE_TOOLKIT_NP_RANKING_NOT_HIGH_SCORE							0x85000004	///< An error occurred because the user's score was not the high score.
#define SCE_TOOLKIT_NP_RANKING_NO_FRIEND_CACHE							0x85000005	///< An error occurred because there was no cache for a friend.
#define SCE_TOOLKIT_NP_RANKING_NO_MATCHING_SCORE						0x85000006	///< An error occurred because the same score was not found in the write cache.
#define SCE_TOOLKIT_NP_RANKING_FRIEND_LIST_EMPTY						0x85000007	///< An error occurred because there was no friends rank in the leaderboard.
#define SCE_TOOLKIT_NP_RANKING_NO_FRIEND_RANK							0x85000008	///< An error occurred because there was no previous score in the friend cache.
#define SCE_TOOLKIT_NP_RANKING_NO_RANK_IN_READ_CACHE					0x85000009	///< An error occurred because there was no previous score in the read cache.
#define SCE_TOOLKIT_NP_RANKING_NO_SCORES								0x8500000A	///< An error occurred because there was no previous score in the write cache.
#define SCE_TOOLKIT_NP_RANKING_RANGE_INVALID							0x8500000B	///< An error occurred because there the range specified was too big.
#define SCE_TOOLKIT_NP_RANKING_INVALID_BOARD							0x8500000C	///< An error occurred because an invalid board ID was passed into ranking functions.
#define SCE_TOOLKIT_NP_RANKING_NO_OUTSTANDING							0x8500000D	///< An error occurred because all the outstanding scores had been registered from the log.
#define SCE_TOOLKIT_NP_RANKING_NOT_TERMINATED							0x8500000E	///< An error occurred because the ranking service has not been terminated.
#define SCE_TOOLKIT_NP_RANKING_REQUEST_ABORTED							0x85000016	///< An error occurred because the ranking request has been aborted.

//e-Matching Errors
#define SCE_TOOLKIT_NP_MATCHING_INVALID_SESSION_DESC					0x86000001	///< An error occurred because a create session descriptor was invalid.  
#define SCE_TOOLKIT_NP_MATCHING_SESSION_CREATION_FAILED					0x86000003	///< An error occurred during creation of a session. 
#define SCE_TOOLKIT_NP_MATCHING_CALLBACK_FAILURE_ERROR					0x86000004  ///< An error occurred because there an internal failure during processing of a request.
#define SCE_TOOLKIT_NP_MATCHING_SERVICE_BUSY							0x86000005	///< An error occurred because the previous operation requested by the application was still being processed.
#define SCE_TOOLKIT_NP_MATCHING_SESSION_ALREADY_ACTIVE					0x86000006	///< An error occurred because a session can be created or joined when the user is already in a session. 
#define SCE_TOOLKIT_NP_MATCHING_INVALID_PARAMETERS						0x86000007	///< An error occurred because invalid parameters were passed in when registering session attributes.
#define SCE_TOOLKIT_NP_MATCHING_INVALID_SEARCH_CRITERIA					0x86000008  ///< An error occurred because invalid search criteria were passed in. 
#define SCE_TOOLKIT_NP_MATCHING_SEARCH_FAILED							0x86000009	///< An error occurred while searching for a session
#define SCE_TOOLKIT_NP_MATCHING_INVALID_JOIN_DESCRIPTOR					0x8600000A	///< An error occurred because the join descriptor parameters are invalid. 
#define SCE_TOOLKIT_NP_MATCHING_JOIN_FAILED								0x8600000B  ///< An error occurred because the operation failed to join a session. 
#define SCE_TOOLKIT_NP_MATCHING_FAIL_TO_REGISTER_ATTRIBUTES				0x8600000C  ///< An error occurred because the operation failed to register session attributes.
#define SCE_TOOLKIT_NP_MATCHING_INVALID_ROOM_ID							0x8600000D  ///< An error occurred because an invalid room ID was passed in. 
#define SCE_TOOLKIT_NP_MATCHING_LEAVING_FAILED							0x8600000E	///< An error occurred because the operation failed to leave a session.
#define SCE_TOOLKIT_NP_MATCHING_NO_SESSION_TO_JOIN						0x8600000F	///< An error occurred because there was no session to join.
#define SCE_TOOLKIT_NP_SESSION_ATTRIBUTE_NOT_REGISTERED					0x86000011	///< An error occurred because the session attribute are not registered. 
#define SCE_TOOLKIT_NP_INVALID_NUM_SESSION_ATTRIBUTES					0x86000012  ///< An error occurred because there was an invalid number of session attributes. The maximum is 64.
#define SCE_TOOLKIT_NP_MATCHING_SESSION_DOES_NOT_EXIST					0x86000013	///< An error occurred because the session does not exist.
#define SCE_TOOLKIT_NP_MATCHING_SESSION_ROOM_DESTROYED					0x86000014	///< An error occurred because the session has been destroyed.
#define SCE_TOOLKIT_NP_MATCHING_SESSION_KICKEDOUT						0x86000015  ///< An error occurred because the user has been kicked out of the current session. 
#define SCE_TOOLKIT_NP_MATCHING_SESSION_UPDATE_FAILED					0x86000016	///< An error occurred because the operation failed to update the current session. 
#define SCE_TOOLKIT_NP_MATCHING_INVALID_MODIFY_ATTRIBUTES				0x86000017	///< An error occurred because the operation failed to modify the current session attributes. 
#define SCE_TOOLKIT_NP_MATCHING_NO_SESSION_ACTIVE						0x86000018	///< An error occurred because the operation failed to modify the current session as the session you trying to update is not active. 
#define SCE_TOOLKIT_NP_MATCHING_ATTRIBUTES_ALREADY_REGISTERED			0x86000019	///< An error occurred because the session attributes where already registered.
#define SCE_TOOLKIT_NP_MATCHING_INVALID_ROOM_MESSAGE					0x8600001A	///< An error occurred because the wrong message flag was specified.
#define SCE_TOOLKIT_NP_MATCHING_INVALID_SLOTS_INFORMATION				0x8600001B	///< An error occurred because the worng combination of slotsInformation for the session.

#ifndef DOXYGEN_IGNORE
/// [Note to Editor: Not to be documented for this revision ]
// SNS Errors
#define SCE_TOOLKIT_NP_SNS_PUBLISHING_DISABLED										0x87000001
#define SCE_TOOLKIT_NP_SNS_ACCESS_TOKEN_ERROR										0x87000002
#define SCE_TOOLKIT_NP_SNS_INVALID_MESSAGE											0x87000003
#define SCE_TOOLKIT_NP_SNS_MESSAGE_POST_FAILED										0x87000004
#define SCE_TOOLKIT_NP_SNS_THROTTLE_TIMER_NOT_READY								0x87000005
#endif

// Word filter
#define SCE_TOOLKIT_NP_WORD_FILTER_SLOT_FULL							0x8A000001	///< An error occurred because more than 16 requests have been made to the word filter service. 
#define SCE_TOOLKIT_NP_WORD_FILTER_NOT_INITIALISED						0x8A000002	///< An error occurred because the word filter service has not been initialized yet.

//e-TSS Errors
#define SCE_TOOLKIT_NP_TSS_NO_DATA										0x8B000001	///< An error occurred because there was no data on the TSS server.

//e-TUS Errors
#define SCE_TOOLKIT_NP_TUS_NO_VARS										0x8C000001	///< An error occurred because an invalid parameter which contained no variables was passed into a function.
#define SCE_TOOLKIT_NP_TUS_NO_DATA										0x8C000002	///< An error occurred because there was no data on the TUS server.

#endif
